%------------------------------------------------------------------------------
% File     : SYO541^1 : TPTP v9.2.0. Released v5.2.0.
% Domain   : Syntactic
% Problem  : If-then-else on $i>$i defined from choice on $i>$i
% Version  : Especial.
% English  : A choice operator on ($i>$i) is used to define an if-then-else 
%            operator at ($i>$i). Check that it works.

% Refs     : [Bro11] Brown E. (2011), Email to Geoff Sutcliffe
% Source   : [Bro11]
% Names    : CHOICE16 [Bro11]

% Status   : Theorem
% Rating   : 0.22 v9.1.0, 0.25 v9.0.0, 0.30 v8.2.0, 0.38 v8.1.0, 0.18 v7.5.0, 0.14 v7.4.0, 0.22 v7.2.0, 0.12 v7.1.0, 0.25 v7.0.0, 0.14 v6.4.0, 0.17 v6.3.0, 0.20 v6.2.0, 0.43 v6.1.0, 0.29 v5.5.0, 0.33 v5.4.0, 0.40 v5.2.0
% Syntax   : Number of formulae    :    5 (   1 unt;   2 typ;   1 def)
%            Number of atoms       :    7 (   5 equ;   0 cnn)
%            Maximal formula atoms :    2 (   2 avg)
%            Number of connectives :   16 (   1   ~;   1   |;   3   &;  10   @)
%                                         (   0 <=>;   1  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    5 (   3 avg)
%            Number of types       :    2 (   0 usr)
%            Number of type conns  :   18 (  18   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    5 (   2 usr;   2 con; 0-4 aty)
%            Number of variables   :    8 (   4   ^;   3   !;   1   ?;   8   :)
% SPC      : TH0_THM_EQU_NAR

% Comments : 
%------------------------------------------------------------------------------
thf(epsii,type,
    epsii: ( ( $i > $i ) > $o ) > $i > $i ).

thf(choiceaxii,axiom,
    ! [P: ( $i > $i ) > $o] :
      ( ? [X: $i > $i] : ( P @ X )
     => ( P @ ( epsii @ P ) ) ) ).

thf(if,type,
    if: $o > ( $i > $i ) > ( $i > $i ) > $i > $i ).

thf(ifd,definition,
    ( if
    = ( ^ [B: $o,X: $i > $i,Y: $i > $i] :
          ( epsii
          @ ^ [Z: $i > $i] :
              ( ( B
                & ( Z = X ) )
              | ( ~ B
                & ( Z = Y ) ) ) ) ) ) ).

thf(conj,conjecture,
    ! [X: $i > $i,Y: $i > $i] :
      ( ( ( if @ $true @ X @ Y )
        = X )
      & ( ( if @ $false @ X @ Y )
        = Y ) ) ).

%------------------------------------------------------------------------------
